
local OH_6_FIM_92 = {
	category		= CAT_AIR_TO_AIR,  
	name			= "OH_6_FIM_92",
	user_name	 	= _("FIM-92"),
	scheme			= "self_homing_spin_missile2",  
	class_name		= "wAmmunitionSelfHoming",
	model			= "OH58D_FIM_92",
	wsTypeOfWeapon  = {wsType_Weapon,wsType_Missile,wsType_AA_Missile,WSTYPE_PLACEHOLDER},
    Escort = 0,
    Head_Type = 1,
	sigma = {3, 3, 3},
    M = 10.1,
    H_max = 3500.0,
    H_min = 1.0,
    Diam = 70.0,
    Cx_pil = 1,
    D_max = 5000.0,
    D_min = 200.0,
    Head_Form = 1,
    Life_Time = 30.0,
    Nr_max = 18,
    v_min = 70.0,
    v_mid = 300.0,
    Mach_max = 2.2,
    t_b = 0.0,
    t_acc = 3.0,
    t_marsh = 3.0,
    Range_max = 6000.0,
    H_min_t = 10.0,
    Fi_start = math.rad(1),
    Fi_rak = 3.14152,
    Fi_excort = 0.7,
    Fi_search = 99.9,
    OmViz_max = 99.9,
    X_back = 0,
    Y_back = 0.0,
    Z_back = 0.0,
    Reflection = 0.01,
    KillDistance = 7.0, 
		
	SeekerGen = 4,     
	SeekerSensivityDistance = 30000, -- The range of target with IR value = 1. In meters.
	ccm_k0 					= 0.01,  -- Counter Countermeasures Probability Factor. Value = 0 - missile has absolutely resistance to countermeasures. Default = 1 (medium probability)
	SeekerCooled			= true, -- True is cooled seeker and false is not cooled seeker.	
	
	shape_table_data =
	{
		{
			name		= "OH_6_FIM_92",
			file		= "OH58D_FIM_92",
			life		= 1,
			fire		= { 0, 1},
			username	= _("FIM-92"),
			index		= FIM_92C,
		},
	},

	controller = {
		boost_start = 0,
		march_start = 0.4,
		march2_start = 3.1,
	},

	booster = {
		impulse								= 190,
		fuel_mass							= 0.1,
		work_time							= 0.05,
		boost_time							= 0,
		boost_factor						= 0,
		nozzle_position						= {{-0.79, 0, 0}},
		nozzle_orientationXYZ				= {{0, 0, 0}},
		tail_width							= 0.216,
		smoke_color							= {0.7, 0.7, 0.7},
		smoke_transparency					= 0.9,
		custom_smoke_dissipation_factor		= 0.01,
		max_effect_length					= 10e3,
		-- jettisoned booster params
		model_name					= "mistral_booster", -- TODO replace model
		wind_sigma					= 0.0,
		moment_sigma				= 10.0,
		impulse_sigma				= 1,
		start_impulse				= 1,
		mass						= 1.0,
		caliber						= 0.1,
		L							= 0.1,
		I							= 1,
		Ma							= 0.05,
		Mw							= 1e-4,
		Cx							= 0.9,
	},

	march = {
		impulse								= 232,
		fuel_mass							= 2.52,
		work_time							= 2.7,
		boost_time							= 0,
		boost_factor						= 0,
		nozzle_position						= {{-0.79, 0, 0}},
		nozzle_orientationXYZ				= {{0, 0, 0}},
		tail_width							= 0.216,
		smoke_color							= {0.7, 0.7, 0.7},
		smoke_transparency					= 1,
		custom_smoke_dissipation_factor		= 0.01,
		max_effect_length					= 10e4
	},

	march2 = {
		impulse								= 225,
		fuel_mass							= 2.04,
		work_time							= 5.1,
		boost_time							= 0,
		boost_factor						= 0,
		nozzle_position						= {{-0.79, 0, 0}},
		nozzle_orientationXYZ				= {{0, 0, 0}},
		tail_width							= 0.216,
		smoke_color							= {0.7, 0.7, 0.7},
		smoke_transparency					= 1,
		custom_smoke_dissipation_factor		= 0.01,
		max_effect_length					= 10e4
	},

	fm = {
		mass			= 10.1,
		caliber			= 0.072,
		cx_coeff		= {1, 1.15, 0.8, 0.4, 1.5},
		L				= 1.52,
		I				= 1 / 12 * 10.6 * 1.52 ^ 2,
		Ma				= 0.6,
		Mw				= 1.2,
		Sw				= 0.2,
		dCydA			= {0.07, 0.036},
		A				= 0.6,
		maxAoa			= 0.3,
		finsTau			= 0.1,
		freq			= 20,
	},

	simple_IR_seeker = {
		sensitivity		= 30000,
		cooled			= true,
		delay			= 0,
		FOV				= math.rad(30);   
		opTime			= 15,
		target_H_min	= 0,
		flag_dist		= 150,
		abs_err_val		= 2,
		ground_err_k	= 3,
		ccm_k0			= 0.01,
	},

	simple_gyrostab_seeker = {
		omega_max = math.rad(30),  
		gimbal_lim = math.rad(30), 
	},

	--fuze = {
		--default_self_destruct_delay	= 17,
		--fuze_time_sigma				= 0.9  
    
	proximity_fuze = {
        radius      = 10.0,  
        arm_delay   = 2,		
		
	},

	autopilot = {
		K				= 2,
		Kg				= 0.1,
		Ki				= 0,
		finsLimit		= 0.2,
		delay 			= 0.5,
		fin2_coeff		= 0.5,
	},

	warhead		= predefined_warhead("AIM_120"), 
	warhead_air	= predefined_warhead("AIM_120")  
}
declare_weapon(OH_6_FIM_92)

declare_loadout(
{
	category 		= CAT_AIR_TO_AIR,
	CLSID	 		= "OH_6_FIM_92_R",
	attribute		= {wsType_Weapon,wsType_Missile,wsType_Container,WSTYPE_PLACEHOLDER},
	wsTypeOfWeapon	= OH_6_FIM_92.wsTypeOfWeapon,
	--wsTypeOfWeapon	= {4,	4,	34,	93},
	Count 			= 2,
	Picture			= "OH58D_FIM_92.png",
	displayName		= "2xFIM-92",
	--Weight			= (2*OH58D_FIM_92.M) + 16.42+3.65+2.13,
	Weight			= (2*10.3) + 16.42+3.65+2.13, -- FIM-92 15.19 kg -- launcher 16.42 kg -- bras armé 3.65 kg -- cablage 2.13 kg
	--Weight			= (2*15.19) + 16.42+3.65+2.13, -- FIM-92 15.19 kg -- launcher 16.42 kg -- bras armé 3.65 kg -- cablage 2.13 kg
	Cx_pil			= 0.001,
	Elements		=
	{
		{
			ShapeName	=	"OH58D_SRACK_R",  
			IsAdapter   =   true,
		},
		{
			ShapeName	=	"OH58D_FIM_92",
			connector_name = "ATAS_pt002",
		}, 
		{
			ShapeName	=	"OH58D_FIM_92",
			connector_name = "ATAS_pt1", 
		}, 
	},
}
)


declare_loadout(
{
	category 		= CAT_AIR_TO_AIR,
	CLSID	 		= "OH_6_FIM_92_L",
	attribute		= {wsType_Weapon,wsType_Missile,wsType_Container,WSTYPE_PLACEHOLDER},
	wsTypeOfWeapon	= OH_6_FIM_92.wsTypeOfWeapon,  
	--wsTypeOfWeapon	= {4,	4,	34,	93},
	Count 			= 2,
	Picture			= "OH58D_FIM_92.png",
	displayName		= "2xFIM-92",
	--Weight			= (2*OH58D_FIM_92.M) + + 16.42+3.65+2.13,
	--Weight			= (2*15.19) + 16.42+3.65+2.13, -- FIM-92 15.19 kg -- launcher 16.42 kg -- bras armé 3.65 kg -- cablage 2.13 kg
	Weight			= (2*10.3) + 16.42+3.65+2.13, -- FIM-92 15.19 kg -- launcher 16.42 kg -- bras armé 3.65 kg -- cablage 2.13 kg
	Cx_pil			= 0.001,
	Elements		=
	{
		{
			ShapeName	=	"OH58D_SRACK_L",
			IsAdapter   =   true,
		},
		{
			ShapeName	=	"OH58D_FIM_92",
			connector_name = "ATAS_pt1",
		}, 
		{
			ShapeName	=	"OH58D_FIM_92",
			connector_name = "ATAS_pt002",
		} 
	},
}
)

